﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ApartmentDoor : Interactable
{
    public GameObject[] objectsToDeactivateWhenFlagIsAccquired;
    public GameObject[] objectsToActivateWhenFlagIsAcquired;

    override public bool Interact()
    {
        if (GameController.instance.HasFlag("Coffee Hint") && !GameController.instance.HasFlag("True Coffee Beans"))
        {
            GameController.instance.AddFlag("True Coffee Beans");
            GameController.instance.StartDialog(new string[] { "You got the special blend, it's placed in the counter." });

            foreach (GameObject go in objectsToDeactivateWhenFlagIsAccquired)
            {
                go.SetActive(false);
            }

            foreach (GameObject go in objectsToActivateWhenFlagIsAcquired)
            {
                go.SetActive(true);
            }

            return true;
        }

        if (GameController.instance.HasFlag("Bread") || GameController.instance.HasFlag("True Bread") || GameController.instance.HasFlag("Coffee") || GameController.instance.HasFlag("True Coffee"))
        {
            GameController.instance.StartConfirmExitDialogController();
            return true;
        }

        GameController.instance.StartDialog(new string[] { "It's the entrance to the apartment, there’s a small slot for mail." });
        return true;
    }
}
